jQuery(document).ready(function ($) {

    $('#sil-analyze').on('click', function () {
        const btn = $(this);
        const postId = $('#sil-post-id').val() || $('#post_ID').val();

        if (!postId) {
            return;
        }

        btn.prop('disabled', true).html('<span class="dashicons dashicons-update spin"></span> Analyzing...');

        $.post(silData.ajax_url, {
            action: 'sil_analyze',
            nonce: silData.nonce,
            post_id: postId
        }, function (response) {
            if (response.success) {
                displaySuggestions(response.data);
            }
            btn.prop('disabled', false).html('<span class="dashicons dashicons-search"></span> Analyze Content');
        });
    });

    function displaySuggestions(suggestions) {
        const tbody = $('#sil-tbody');
        tbody.empty();

        if (suggestions.length === 0) {
            tbody.append('<tr><td colspan="4" style="text-align:center;padding:20px;color:#666;">No internal linking opportunities found</td></tr>');
            return;
        }

        suggestions.forEach(function (s) {
            const strengthClass = s.strength === 'Strong' ? 'strength-strong' : 'strength-normal';
            const actionContent = s.is_linked ?
                '<span class="link-success"><span class="dashicons dashicons-yes-alt"></span> Linked</span>' :
                `<button class="sil-add-link" data-anchor="${s.anchor}" data-url="${s.target_url}">Add Link</button>`;

            const row = `
                <tr data-anchor="${s.anchor}">
                    <td class="column-anchor"><strong>${s.anchor}</strong></td>
                    <td class="column-strength">
                        <span class="strength-badge ${strengthClass}">${s.strength}</span>
                    </td>
                    <td class="column-target">
                        <a href="${s.target_url}" target="_blank" class="target-link">${s.target_title}</a>
                    </td>
                    <td class="column-action">
                        ${actionContent}
                    </td>
                </tr>
            `;
            tbody.append(row);
        });
    }

    $(document).on('click', '.sil-add-link', function () {
        const btn = $(this);
        const row = btn.closest('tr');
        const anchor = btn.data('anchor');
        const url = btn.data('url');
        const postId = $('#sil-post-id').val() || $('#post_ID').val();

        btn.prop('disabled', true).text('Adding...');

        $.post(silData.ajax_url, {
            action: 'sil_add_link',
            nonce: silData.nonce,
            post_id: postId,
            anchor: anchor,
            target_url: url
        }, function (response) {
            if (response.success) {
                if (typeof tinymce !== 'undefined' && tinymce.get('content')) {
                    tinymce.get('content').setContent(response.data.content);
                } else {
                    $('#content').val(response.data.content);
                }

                row.find('.column-action').html('<span class="link-success"><span class="dashicons dashicons-yes-alt"></span> Linked</span>');

                showWordPressNotice('Internal Link Added Successfully');

                setTimeout(function () {
                    location.reload();
                }, 2000);
            } else {
                btn.prop('disabled', false).text('Add Link');
            }
        });
    });

    function showWordPressNotice(message) {
        const notice = $(`
            <div class="notice notice-success is-dismissible" style="position:fixed;bottom:20px;left:20px;z-index:9999;max-width:400px;">
                <p><strong>${message}</strong></p>
                <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>
            </div>
        `);

        $('body').append(notice);

        notice.find('.notice-dismiss').on('click', function () {
            notice.remove();
        });

        setTimeout(function () {
            notice.fadeOut(function () {
                notice.remove();
            });
        }, 5000);
    }

    function get_permalink(postId) {
        return window.location.origin + '/?p=' + postId;
    }

});
